<?php
    
define( "BANK_DIR", __DIR__ );

# Uss::route is user synthetics default method of focusing on a URL

# Require and Initialize Banking System;

$vendor = __DIR__ . "/vendor/autoload.php";
if( is_file($vendor) ) {
    // Load Composer Autoload
    require_once( $vendor );
};

require_once __DIR__ . "/Converter.php";
require_once __DIR__ . "/AbstractBank.php";
require_once __DIR__ . "/Bank.php";

require_once Bank::HOME_DIR . "/resource/home.class.php";

 # Process Front Page;

Events::addListener('udash:ready', function() {
    
    Bank::init();

    //Udash::config('debug', true);

    require_once Bank::HOME_DIR . "/index.php";
    
    Bank::ready(function() {
        
        require_once Bank::GENERAL_DIR . "/index.php";

        require_once Bank::CLIENT_DIR . "/index.php";

        require_once Bank::ADMIN_DIR . "/index.php";

    });

}, 'Bank');


# Process Dashboard Page

Events::addListener('udash:ready', function() {
    
    /**
     * Udash::load is uss dashboard method of securing an environment.
     * It takes over a url and all of the url descendants
     */
    Udash::load("dashboard", function() {

        require_once Bank::CLIENT_DIR . "/__control/autoload.php";
        
        Bank::ready(function() {

            $subset = array(
                "account",
                "transfer",
                "monetary",
                "loan"
            );

            foreach( $subset as $folder ) {

                # Autoload Required Data
                require_once Bank::CLIENT_DIR . "/{$folder}/autoload.php";

            };

        });

    });

}, 'bank');


# Process Admin Page

Events::addListener('uadmin:ready', function() {

    /**
     * Handle Queries in admin section;
     */
    Udash::load('admin', function() {

        $user = Uss::$global['user'];

        if( !$user || !Roles::user($user['id'])::hasPermission('view-cpanel') ) return;

        $subset = array(
            "user-accounts",
            "managements",
            "gateway",
            "finance",
            "configure",
            "broadcast",
            "misc"
        );

        foreach( $subset as $folder ) {

            # Require Autoloads;
            require_once Bank::ADMIN_DIR . "/{$folder}/autoload.php";

        };

        Uss::$global['menu']->add('logout', [
            "label" => "logout",
            "icon" => "<i class='bi bi-person-fill-slash'></i>",
            "href" => Core::url( ROOT_DIR . "/" . Udash::config('page:signout') ),
            "order" => 100
        ]);

    });
    
}, 'bank');
